﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;

namespace ErrorExample
{
    // Przykład 6-5. Sprawdzanie zakresów.
    class Turtle
    {
        // Szerokość platformy musi być większa lub równa 1.0 i mniejsza lub 
        // równa 10.0. Wartości wykraczające poza ten zakres zostaną zamienione
        // na odpowiednie wartości skrajne.
        private double platformWidth;
        public double PlatformWidth
        {
            get { return platformWidth; }
            set
            {
                platformWidth = value;
                EnsurePlatformSize();
            }
        }
        // Wysokość platformy musi być większa lub równa 1.0 i mniejsza lub 
        // równa 10.0. Wartości wykraczające poza ten zakres zostaną zamienione
        // na odpowiednie wartości skrajne.
        private double platformHeight;
        public double PlatformHeight
        {
            get { return platformHeight; }
            set
            {
                platformHeight = value;
                EnsurePlatformSize();
            }
        }

        // Nowy konstruktor prawidłowo inicjuje szerokość platformy robota.
        public Turtle()
        {
            EnsurePlatformSize();
        }

        // Ta metoda wymusza zastosowanie się do określonych powyżej wymogów, które właśnie 
        // dodaliśmy do kontraktu klasy.
        private void EnsurePlatformSize()
        {
            if (PlatformWidth < 1.0)
            {
                PlatformWidth = 1.0;
            }
            if (PlatformWidth > 10.0)
            {
                PlatformWidth = 10.0;
            }
            if (PlatformHeight < 1.0)
            {
                PlatformHeight = 1.0;
            }
            if (PlatformHeight > 10.0)
            {
                PlatformHeight = 10.0;
            }
        }

        // Szybkość, z jaką silniczki kręcą kółkami,
        // wyrażona w metrach na sekundę. Dla ułatwienia zakładamy,
        // że została ona określona na podstawie dystansu, jaki pokonały 
        // kółka robota na powierzchni, po której się porusza
        // (i ewentualnych poślizgów).
        public double MotorSpeed
        {
            get;
            set;
        }

        // Stan lewego silniczka
        public MotorState LeftMotorState
        {
            get;
            set;
        }

        // Stan prawego silniczka
        public MotorState RightMotorState
        {
            get;
            set;
        }
        
        // Aktualne położenie robota
        public Point CurrentPosition
        {
            get;
            private set;
        }

        // Aktualna orientacja robota
        public double CurrentOrientation
        {
            get;
            private set;
        }


        // Listing 6-2. Symulacja ruchu robota.
        // Robot się prusza przez zadany okres czasu.
        public void RunFor(double duration)
        {
            if (LeftMotorState == MotorState.Stopped &&
            RightMotorState == MotorState.Stopped)
            {
                // Jeśli robot był całkowicie zatrzymany, nic sie nie stanie.
                return;
            }
            // Jeśli oba silniczki pracowały, kręcąc się w tym samym kierunku,
            // to mogliśmy jechać.
            if ((LeftMotorState == MotorState.Running &&
            RightMotorState == MotorState.Running) ||
            (LeftMotorState == MotorState.Reversed &&
                RightMotorState == MotorState.Reversed))
            {
                Drive(duration);
                return;
            }
            // Silniczki kręcą się w przeciwnych kierunkach,
            // zatem robot nie jedzie do przodu, a jedynie kręci 
            // się wokół swego środka.
            if ((LeftMotorState == MotorState.Running &&
            RightMotorState == MotorState.Reversed) ||
            (LeftMotorState == MotorState.Reversed &&
            RightMotorState == MotorState.Running))
            {
                Rotate(duration);
                return;
            }
        }


        // Listing 6-3. Symulacja obrotów oraz ruchu
        private void Rotate(double duration)
        {
            // Pełna długość okręgu zataczanego przez obracającego się robota
            double circum = Math.PI * PlatformWidth;
            // A to całkowity przebyty dystans
            double d = duration * MotorSpeed;
            if (LeftMotorState == MotorState.Reversed)
            {
                // Jeśli silniczki kręcą się w ty, to jedziemy do tyłu.
                d *= -1.0;
            }
            // Stosunek przebytego dystansu do obwodu pełnego obrotu
            double proportionOfWholeCircle = d / circum;
            // Gdy obrót wyniesie 360 stopni (lub 2pi radianów), to przebyta 
            // odległość wyniesie:
            CurrentOrientation =
                CurrentOrientation + (Math.PI * 2.0 * proportionOfWholeCircle);
        }
        private void Drive(double duration)
        {
            // Całkowity przejechany dystans
            double d = duration * MotorSpeed;
            if (LeftMotorState == MotorState.Reversed)
            {
                // Jeśli silniczki kręcą się w ty, to jedziemy do tyłu.
                d *= -1.0;
            }
            // Nieco obliczeń trygonometrycznych w celu określenia zmiany
            // współrzędnych x i y
            double deltaX = d * Math.Sin(CurrentOrientation);
            double deltaY = d * Math.Cos(CurrentOrientation);
            // Zaktualizowane położenie robota
            CurrentPosition =
            new Point(CurrentPosition.X + deltaX, CurrentPosition.Y + deltaY);
        }
    }

    // Aktualny stan silniczka
    enum MotorState
    {
        Stopped,
        Running,
        Reversed
    }
}